/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.single;

import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Single;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.SingleObserver;
import dev.compactmods.crafting.lib.reactivex.rxjava3.exceptions.Exceptions;
import dev.compactmods.crafting.lib.reactivex.rxjava3.functions.Supplier;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.util.ExceptionHelper;

public final class SingleError<T>
extends Single<T> {
    final Supplier<? extends Throwable> errorSupplier;

    public SingleError(Supplier<? extends Throwable> errorSupplier) {
        this.errorSupplier = errorSupplier;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> observer) {
        Throwable error;
        try {
            error = ExceptionHelper.nullCheck(this.errorSupplier.get(), "Supplier returned a null Throwable.");
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            error = e;
        }
        EmptyDisposable.error(error, observer);
    }
}

